<?php

class Cadastros {

    private $id_cadastro;
    private $hash_user;
    private $email;
    private $senha;
    private $datadecadastro;
    private $status;
    private $razaosocial;
    private $nomefantasia;
    private $cnpj;
    private $cpf;
    private $pnome;
    private $nome;
    private $sobrenome;
    private $nomecompleto;
    private $datanascimento;
    private $genero;
    private $uf;
    private $cidade;
    private $bairro;
    private $logradouro;
    private $numero;
    private $complemento;
    private $cep;
    private $telefoneresidencial;
    private $telefonecelular;
    private $foto;
    private $autorizado;

    function VerificaSessao() {
        if (empty($_SESSION['hash_5cd'])) {
            $urla = explode('/', $_SERVER['REQUEST_URI']);
            echo "<script>
             window.location.href = \"/app/login/?ref=" . $urla['2'] . "\";
             </script>";
            exit;
        } else {
            return true;
        }
    }

    function Cadastra_Usuario($nomecompleto, $email, $celular, $estado, $cidade, $senha_user) {
        include __DIR__ . "/../functions/connect.php";

        // Criar o HASH
        $this->hash_user = md5($email . $nomecompleto);
        $this->nome = $nomecompleto;
        $this->email = $email;
        $this->senha = md5($senha_user);
        $this->status = 0;
        $this->telefonecelular = $celular;
        $this->uf = $estado;
        $this->cidade = $cidade;

        // fuso data e hora atual
        date_default_timezone_set('America/Sao_Paulo');
        $this->datadecadastro = new DateTime();

        $sql = "INSERT INTO 4f_cadastros 
		SET hash_user = ?, email = ?, senha = ?, datadecadastro = ?, status = ?, nome = ?, uf = ?, cidade = ?, telefonecelular = ?";

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('ssssissss', $this->hash_user, $this->email, $this->senha, $this->datadecadastro->format("Y-m-d H:i:s"), $this->status, $this->nome, $this->uf, $this->cidade, $this->telefonecelular);
        $stmt->execute();
        $stmt->close();

        $this->pnome = explode(" ", $this->nome);
        $this->pnome = $this->pnome[0];

        $assuntoemail = $this->pnome . ", ative seu cadastro no 4Fretes!";
        $titulomsg = "Confirme seu email";
        $tokenconfirmacao = md5($this->email . $this->telefonecelular);

        $msgemail = "<h1 style=\"color:#333333;font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif;font-size:30px;font-weight:300;line-height:120%;margin:0;text-align:center;\">Olá, $this->nome!</h1>
	
	<p style=\"color:#666666;font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif;font-size:16px;font-weight:300;line-height:150%;margin:0;text-align:center;\">É necessário que você confirme seu endereço de email. É só clicar no botão abaixo. :)</p>";

        $rodapeemail = "<a href=\"https://www.4fretes.com/confirmacao/$tokenconfirmacao/$this->email\" title=\"Clique aqui para confirmar seu email\" style=\"color:white;text-decoration:none;background-color:#00468C;display:inline-block;border-radius:3px;padding:0.75em;border-bottom:3px solid #000033; font-size:14px; min-height: 30px; width:270px;height:26px;line-height:26px; font-weight:bold; margin-top:24px;margin-bottom:10px\" target=\"_blank\"><span class=\"il\">CONFIRMAR</span> EMAIL</a><p style=\"margin:0px 0;font-size:12px;color:#666666;font-weight:lighter;line-height:20px\">
                            Se tiver problemas, copie e cole o link a seguir em outra janela do seu navegador: https://www.4fretes.com/confirmacao/$tokenconfirmacao/$this->email</p> \n  \n";



        $this->Email_PreCadastro($this->nome, $this->email, $assuntoemail, $msgemail, $titulomsg, $rodapeemail);

        // Cria a sessão e envia o email cadastrado para continuar o cadastro.
        $_SESSION['temp_hash'] = $this->hash_user;

        // Redireciona para continuar o cadastro 
        echo "<script>
		window.location.href = \"/app/quase-la\";
            </script>";

        return true;
    }

    function Email_PreCadastro($nome, $email, $assuntoemail, $msgemail, $titulomsg, $rodapeemail) {

        session_start();
        include "./functions/connect.php";

        // emails para quem será enviado o formulário
        $de = "no-reply@4fretes.com";
        $destino = $email;
        $assunto = $assuntoemail;

        // Adiciona o arquivo class.phpmailer.php - você deve especificar corretamente o caminho da pasta com o este arquivo.
        require_once("./autenvio/PHPMailerAutoload.php");
        // Inicia a classe PHPMailer
        $mail = new PHPMailer();

        // DEFINIÇÃO DOS DADOS DE AUTENTICAÇÃO - Você deve auterar conforme o seu domínio!
        $mail->IsSMTP(); // Define que a mensagem será SMTP
        $mail->Host = "mail.4fretes.com "; // Seu endereço de host SMTP
        $mail->SMTPAuth = true; // Define que será utilizada a autenticação -  Mantenha o valor "true"
        $mail->Port = 587; // Porta de comunicação SMTP - Mantenha o valor "587"
        $mail->SMTPSecure = false; // Define se é utilizado SSL/TLS - Mantenha o valor "false"
        $mail->SMTPAutoTLS = false; // Define se, por padrão, será utilizado TLS - Mantenha o valor "false"
        $mail->Username = 'no-reply@4fretes.com'; // Conta de email existente e ativa em seu domínio
        $mail->Password = 'n321reply'; // Senha da sua conta de email
        // DADOS DO REMETENTE
        $mail->Sender = "no-reply@4fretes.com"; // Conta de email existente e ativa em seu domínio
        $mail->From = "no-reply@4fretes.com"; // Sua conta de email que será remetente da mensagem
        $mail->FromName = "4Fretes.com"; // Nome da conta de email
        // DADOS DO DESTINATÁRIO
        $mail->AddAddress("$email", "$nome"); // Define qual conta de email receberá a mensagem
        //$mail->AddAddress('felipesestevam@gmail.com'); // Define qual conta de email receberá a mensagem
        //$mail->AddCC('copia@dominio.net'); // Define qual conta de email receberá uma cópia
        $mail->AddBCC('felipesestevam@gmail.com'); // Define qual conta de email receberá uma cópia oculta
        // Definição de HTML/codificação
        $mail->IsHTML(true); // Define que o e-mail será enviado como HTML
        $mail->CharSet = 'utf-8'; // Charset da mensagem (opcional)
        // DEFINIÇÃO DA MENSAGEM
        $mail->Subject = "$assunto"; // Assunto da mensagem
        $mail->Body .= "<div style=\"background: #efefef; width: 100%; padding:30px 0;\"><div style=\"max-width: 600px; margin: 0 auto;  text-align:center; \">";
        $mail->Body .= "<img src=\"http://www.4fretes.com/images/logo-4fretes.png\" align=\"center\" alt=\"\"> <br><br><br>";

        $mail->Body .= "<div style=\"width: 100%; margin: 0 auto; border:1px solid #cccccc; background: #ffffff; text-align:center; border-radius:3px !important; \">";
        $mail->Body .= "<div style=\"max-width: 100%; background: #002040; border-radius:3px 3px 0 0!important; padding:20px;\"> ";
        $mail->Body .= "<h1 style=\"color:#ffffff;font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif;font-size:30px;font-weight:300;line-height:110%;margin:0;text-align:center;\">$titulomsg</h1> ";
        $mail->Body .= "</div><br><br>";


        $mail->Body .= "<div style=\"width: 70%; margin: 0 auto; line-height:150%;\">$msgemail</div> <br>";

        $mail->Body .= "$rodapeemail";

        $mail->Body .= "<br><br><div style=\"margin: 0 auto; height: 35px; padding:10px 0 0 0; width:80%; border-top:1px solid #e2e2e2; font-size:10px;color:#666666\">EQUIPE <span style=\"color:#000000;font-weight:800;text-transform:uppercase\">4Fretes.com</span></div>";

        $mail->Body .= "</div>";
        $mail->Body .= "<br><br> Esta é uma mensagem automática, favor não responder este email. \n</div>";
        $mail->Body .= "</div>";


        // ENVIO DO EMAIL
        $enviado = $mail->Send();
        // Limpa os destinatários e os anexos
        $mail->ClearAllRecipients();

        // Exibe uma mensagem de resultado do envio (sucesso/erro)
        if ($enviado) {
            return true;
        } else {
            echo "Não foi possível enviar o e-mail.";
            echo "<b>Detalhes do erro:</b> " . $mail->ErrorInfo;
            exit;
        }
    }

    function getTempHash() {
        if ($_SESSION['temp_hash']) {
            session_start();
            include "./functions/connect.php";

            $sql = "SELECT email, status, nome "
                    . "FROM 4f_cadastros "
                    . "WHERE hash_user = ? ";

            $stmt = $mysqli->prepare($sql);

            if (!$stmt) {
                echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                return false;
            }

            $stmt->bind_param('s', $_SESSION['temp_hash']);
            $stmt->execute();


            $stmt->bind_result($email_user, $status_user, $nome_user);

            $stmt->store_result();
            //echo $stmt->num_rows();

            if ($stmt->num_rows() === 0) {
                echo "<script>
		window.location.href = \"/app/\";
            </script>";
                exit;
            }

            while ($stmt->fetch()) {
                $nome_user = explode(" ", $nome_user);
                $nome_user = $nome_user[0];

                $dados['email'] = $email_user;
                $dados['status'] = $status_user;
                $dados['nome'] = $nome_user;
            }
            return $dados;
        }
    }

    function Confirma_Cadastro() {
        require_once 'functions/antisqlinjection.php';

        $url = strip_tags($_SERVER['REQUEST_URI']);
        $url_array = explode("/", $url);

        // Excluimos o primeiro elemento, que sempre ser� vazio
        array_shift($url_array);

        $emailvalidar = anti_sql_injection($url_array[3]);
        $codvalidar = anti_sql_injection($url_array[2]);

        include "./functions/connect.php";

        $sql = "SELECT id_cadastro, telefonecelular, nome "
                . "FROM 4f_cadastros WHERE email = ? AND status = ? "
                . "ORDER BY id_cadastro ASC LIMIT 1";

        $mysqli->query($sql);
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $status = 0;

        $stmt->bind_param('si', $emailvalidar, $status);
        $stmt->execute();
        $stmt->store_result();
        $total = $stmt->num_rows();
        $stmt->bind_result($id_cadastro, $telefonecelular, $nome);

        while ($stmt->fetch()) {

            $nome_user = explode(" ", $nome);
            $nome_user = $nome_user[0];


            if (md5($emailvalidar . $telefonecelular) === $codvalidar) {
                $dados['nome'] = $nome_user;
                $dados['id_cadastro'] = $id_cadastro;
                $dados['retorno'] = TRUE;
            }
        }

        if ($dados['retorno'] === TRUE) {
            // ATUALIZA O STATUS
            $sql = "UPDATE 4f_cadastros 
		SET status = ? 
		WHERE email = ?";

            $stmt = $mysqli->prepare($sql);

            if (!$stmt) {
                echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                return false;
            }
            $novostatus = 2;

            $stmt->bind_param('is', $novostatus, $emailvalidar);
            $stmt->execute();

            $this->assinaFREE($dados['id_cadastro']);

            $stmt->close();
        }

        return $dados;
    }

    function assinaFREE($id_cadastro) {
        include __DIR__ . "/../functions/connect.php";

        date_default_timezone_set('America/Sao_Paulo');
        $this->datadecadastro = new DateTime();

        $sql = "INSERT INTO 4f_assinaturas 
		SET id_cadastro = ?, id_plano = ?, dataassinatura = ?, valor = ?, nomeplano = ?, status = ?";

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $id_plano = 1;
        $status = 1;
        $nomeplano = "Plano de Teste";
        $valor = "0.00";

        $stmt->bind_param('iisssi', $id_cadastro, $id_plano, $this->datadecadastro->format("Y-m-d H:i:s"), $valor, $nomeplano, $status);
        $stmt->execute();
        return $stmt->insert_id;
        $stmt->close();
    }

    function OcultaEmail($email) {
        $pattern = "/^([\w_]{2})(.+)([\w_]{2}@)/u";
        $replacement = "$1********$3";
        return preg_replace($pattern, $replacement, $email);
    }

    function Monta_Cadastro() {
        if ($_SESSION['hash_5cd']) {
            session_start();
            include __DIR__ . "/../functions/connect.php";

            $sql = "SELECT id_cadastro, email, datadecadastro, status, cnpj, razaosocial, nomefantasia, cpf, nome, datanascimento, genero, uf, cidade, bairro, logradouro, numero, complemento, cep, telefoneresidencial, telefonecelular, foto, autorizado "
                    . "FROM 4f_cadastros "
                    . "WHERE hash_user = ? ";

            $stmt = $mysqli->prepare($sql);

            if (!$stmt) {
                echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                return false;
            }

            $stmt->bind_param('s', $_SESSION['hash_5cd']);
            $stmt->execute();


            $stmt->bind_result($id_cadastro, $email_user, $datadecadastro, $status_user, $cnpj, $razaosocial, $nomefantasia, $cpf, $nome_user, $datanascimento, $genero, $uf, $cidade, $bairro, $logradouro, $numero, $complemento, $cep, $telefoneresidencial, $telefonecelular, $foto, $autorizado);

            $stmt->store_result();

            if ($stmt->num_rows() === 0) {

                session_destroy();
                echo "<script>
		window.location.href = \"/app/\";
            </script>";

                exit;
            }

            while ($stmt->fetch()) {
                $this->nomecompleto = ucwords(strtolower($nome_user));
                $nome_user = explode(" ", $nome_user);
                $nome_user = $nome_user[0] . " " . $nome_user[1];
                $this->hash_user = $_SESSION['hash_5cd'];
                $this->id_cadastro = $id_cadastro;
                $this->email = $email_user;
                $this->datadecadastro = $datadecadastro;
                $this->status = $status_user;
                $this->cnpj = $cnpj;
                $this->razaosocial = $razaosocial;
                $this->nomefantasia = $nomefantasia;

                $this->cpf = $cpf;
                $this->nome = ucwords(strtolower($nome_user));
                $this->datanascimento = $datanascimento;
                $this->genero = $genero;
                $this->uf = $uf;
                $this->cidade = $cidade;
                $this->bairro = $bairro;
                $this->logradouro = $logradouro;
                $this->numero = $numero;
                $this->complemento = $complemento;
                $this->cep = $cep;
                $this->telefoneresidencial = $telefoneresidencial;
                $this->telefonecelular = $telefonecelular;
                $this->foto = $foto;
                $this->autorizado = $autorizado;
            }
        }
    }

    function AtualizaCadastro($dados) {
        if (!empty($_SESSION['hash_5cd'])) {
            session_start();
            include __DIR__ . "/../functions/connect.php";

            date_default_timezone_set('America/Sao_Paulo');

            $dc = new Cadastros();
            $dc->Monta_Cadastro();

            $dados->tipocad = filter_var($dados->tipocad, FILTER_SANITIZE_STRING);

            if ($dados->tipocad === 'pf' || !empty($dc->getCpf())) {

                //SE FOR PESSOA FÍSICA
                //VERIFICA SE O CPF JÁ ESTÁ CADASTRADO
                $dados->cpf = empty($dc->getCpf()) ? $dados->cpf : $dc->getCpf();

                $sql = "UPDATE 4f_cadastros 
		SET cpf = ?, datanascimento = ?, uf = ?, cidade = ?, bairro = ?, logradouro = ?, numero = ?, complemento = ?, cep = ?, telefoneresidencial = ?, telefonecelular = ?, autorizado = ?
		WHERE id_cadastro = ?";
                $stmt = $mysqli->prepare($sql);

                if (!$stmt) {
                    echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                    return false;
                }

                $dados->cpf = filter_var(preg_replace("/[^0-9]/", "", $dados->cpf), FILTER_VALIDATE_INT);
                $dados->nascimento = date_create_from_format('Y-m-d', $dados->nascimento);
                $dados->uf = filter_var($dados->uf, FILTER_SANITIZE_STRING);
                $dados->cidade = filter_var($dados->cidade, FILTER_VALIDATE_INT);
                $dados->bairro = filter_var($dados->bairro, FILTER_SANITIZE_STRING);
                $dados->endereco = filter_var($dados->endereco, FILTER_SANITIZE_STRING);
                $dados->numero = filter_var($dados->numero, FILTER_SANITIZE_STRING);
                $dados->complemento = filter_var($dados->complemento, FILTER_SANITIZE_STRING);
                $dados->cep = filter_var(preg_replace("/[^0-9]/", "", $dados->cep), FILTER_VALIDATE_INT);
                $dados->telefone = filter_var($dados->telefone, FILTER_SANITIZE_STRING);
                $dados->celular = filter_var($dados->celular, FILTER_SANITIZE_STRING);
                
                $autorizado = 1;

                $stmt->bind_param('ississssissii', $dados->cpf, $dados->nascimento->format("Y-m-d"), $dados->estado, $dados->cidade, $dados->bairro, $dados->endereco, $dados->numero, $dados->complemento, $dados->cep, $dados->telefone, $dados->celular, $autorizado, $dc->getId_cadastro());
                $stmt->execute();
                $stmt->close();
                return true;
                die();
            } elseif ($dados->tipocad === 'pj' || !empty($dc->getCnpj())) {
                //SE FOR PESSOA JURÍDICA
                //VERIFICA SE O CPF JÁ ESTÁ CADASTRADO
                $dados->cnpj = empty($dc->getCnpj()) ? $dados->cnpj : $dc->getCnpj();

                $sql = "UPDATE 4f_cadastros 
		SET cnpj = ?, razaosocial = ?, nomefantasia = ?, uf = ?, cidade = ?, bairro = ?, logradouro = ?, numero = ?, complemento = ?, cep = ?, telefoneresidencial = ?, telefonecelular = ?, autorizado = ?
		WHERE id_cadastro = ?";
                $stmt = $mysqli->prepare($sql);

                if (!$stmt) {
                    echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                    return false;
                }

                $dados->cnpj = filter_var(preg_replace("/[^0-9]/", "", $dados->cnpj), FILTER_VALIDATE_INT);
                $dados->rs = filter_var($dados->rs, FILTER_SANITIZE_STRING);
                $dados->nomefantasia = filter_var($dados->nomefantasia, FILTER_SANITIZE_STRING);
                $dados->uf = filter_var($dados->uf, FILTER_SANITIZE_STRING);
                $dados->cidade = filter_var($dados->cidade, FILTER_VALIDATE_INT);
                $dados->bairro = filter_var($dados->bairro, FILTER_SANITIZE_STRING);
                $dados->endereco = filter_var($dados->endereco, FILTER_SANITIZE_STRING);
                $dados->numero = filter_var($dados->numero, FILTER_SANITIZE_STRING);
                $dados->complemento = filter_var($dados->complemento, FILTER_SANITIZE_STRING);
                $dados->cep = filter_var(preg_replace("/[^0-9]/", "", $dados->cep), FILTER_VALIDATE_INT);
                $dados->telefone = filter_var($dados->telefone, FILTER_SANITIZE_STRING);
                $dados->celular = filter_var($dados->celular, FILTER_SANITIZE_STRING);
                
                $autorizado = 1;

                $stmt->bind_param('isssissssissii', $dados->cnpj, $dados->rs, $dados->nomefantasia, $dados->estado, $dados->cidade, $dados->bairro, $dados->endereco, $dados->numero, $dados->complemento, $dados->cep, $dados->telefone, $dados->celular, $autorizado, $dc->getId_cadastro());
                $stmt->execute();

                $stmt->close();
                return true;
                exit();
            }
        }
    }

    function getStatusAutorizado() {
        switch ($this->getAutorizado()) {
            case 0:
                return '<span class="badge badge-warning">Pendente</span>';
                break;
            case 1:
                return '<span class="badge badge-success">Completo</span>';
                break;
        }
    }

    function getNomecompleto() {
        return $this->nomecompleto;
    }

    function setNomecompleto($nomecompleto) {
        $this->nomecompleto = $nomecompleto;
    }

    function getId_cadastro() {
        return $this->id_cadastro;
    }

    function getHash_user() {
        return $this->hash_user;
    }

    function getRazaosocial() {
        return $this->razaosocial;
    }

    function getNomefantasia() {
        return $this->nomefantasia;
    }

    function getCnpj() {
        return $this->cnpj;
    }

    function setRazaosocial($razaosocial) {
        $this->razaosocial = $razaosocial;
    }

    function setNomefantasia($nomefantasia) {
        $this->nomefantasia = $nomefantasia;
    }

    function setCnpj($cnpj) {
        $this->cnpj = $cnpj;
    }

    function getEmail() {
        return $this->email;
    }

    function getSenha() {
        return $this->senha;
    }

    function getDatadecadastro() {
        return $this->datadecadastro;
    }

    function getStatus() {
        return $this->status;
    }

    function getCpf() {
        return $this->cpf;
    }

    function getFormatCpf() {
        $bloco_1 = substr($this->cpf, 0, 3);
        $bloco_2 = substr($this->cpf, 3, 3);
        $bloco_3 = substr($this->cpf, 6, 3);
        $dig_verificador = substr($this->cpf, -2);
        $cpf_cnpj_formatado = $bloco_1 . "." . $bloco_2 . "." . $bloco_3 . "-" . $dig_verificador;
        return $this->cpf;
    }

    function getNome() {
        return $this->nome;
    }

    function getSobrenome() {
        return $this->sobrenome;
    }

    function getDatanascimento() {
        return $this->datanascimento;
    }

    function getGenero() {
        return $this->genero;
    }

    function getUf() {
        return $this->uf;
    }

    function getCidade() {
        return $this->cidade;
    }

    function getBairro() {
        return $this->bairro;
    }

    function getLogradouro() {
        return $this->logradouro;
    }

    function getNumero() {
        return $this->numero;
    }

    function getComplemento() {
        return $this->complemento;
    }

    function getCep() {
        return $this->cep;
    }

    function getTelefoneresidencial() {
        return $this->telefoneresidencial;
    }

    function getTelefonecelular() {
        return $this->telefonecelular;
    }

    function getFoto() {
        return $this->foto;
    }

    function setId_cadastro($id_cadastro) {
        $this->id_cadastro = $id_cadastro;
    }

    function setHash_user($hash_user) {
        $this->hash_user = $hash_user;
    }

    function setEmail($email) {
        $this->email = $email;
    }

    function setSenha($senha) {
        $this->senha = $senha;
    }

    function setDatadecadastro($datadecadastro) {
        $this->datadecadastro = $datadecadastro;
    }

    function setStatus($status) {
        $this->status = $status;
    }

    function setCpf($cpf) {
        $this->cpf = $cpf;
    }

    function setNome($nome) {
        $this->nome = $nome;
    }

    function setSobrenome($sobrenome) {
        $this->sobrenome = $sobrenome;
    }

    function setDatanascimento($datanascimento) {
        $this->datanascimento = $datanascimento;
    }

    function setGenero($genero) {
        $this->genero = $genero;
    }

    function setUf($uf) {
        $this->uf = $uf;
    }

    function setCidade($cidade) {
        $this->cidade = $cidade;
    }

    function setBairro($bairro) {
        $this->bairro = $bairro;
    }

    function setLogradouro($logradouro) {
        $this->logradouro = $logradouro;
    }

    function setNumero($numero) {
        $this->numero = $numero;
    }

    function setComplemento($complemento) {
        $this->complemento = $complemento;
    }

    function setCep($cep) {
        $this->cep = $cep;
    }

    function setTelefoneresidencial($telefoneresidencial) {
        $this->telefoneresidencial = $telefoneresidencial;
    }

    function setTelefonecelular($telefonecelular) {
        $this->telefonecelular = $telefonecelular;
    }

    function setFoto($foto) {
        $this->foto = $foto;
    }

    function getPnome() {
        $nome = strtolower($this->nome); // Converter o nome todo para minúsculo
        $nome = explode(" ", $nome); // Separa o nome por espaços
        /*
          for ($i = 0; $i < count($nome); $i++) {

          // Tratar cada palavra do nome
          if ($nome[$i] == "de" or $nome[$i] == "da" or $nome[$i] == "e" or $nome[$i] == "dos" or $nome[$i] == "do") {
          $saida .= $nome[$i] . ' '; // Se a palavra estiver dentro das complementares mostrar toda em minúsculo
          } else {
          $saida .= ucfirst($nome[$i]) . ' '; // Se for um nome, mostrar a primeira letra maiúscula
          }
          }
         * 
         */
        return ucfirst($nome[0]);
    }

    function getAutorizado() {
        return $this->autorizado;
    }

    function setPnome($pnome) {
        $this->pnome = $pnome;
    }

    function setAutorizado($autorizado) {
        $this->autorizado = $autorizado;
    }

}

class UploadFoto extends Cadastros {

    private $pasta = "../fotos/";
    private $permitidos = array(".jpg", ".jpeg", ".gif", ".png");
    private $nome_imagem;
    private $tamanho_imagem;
    private $ext;
    private $tamanho;

    function fazUpload() {
        global $mysqli;
        session_start();

        $dc = new Cadastros();
        $dc->Monta_Cadastro();

        if (isset($_POST) && $dc->getHash_user()) {
            $nome_imagem = $_FILES['imagem']['name'];
            $this->tamanho_imagem = $_FILES['imagem']['size'];

            /* pega a extensão do arquivo */
            $this->ext = strtolower(strrchr($nome_imagem, "."));

            if (in_array($this->ext, $this->permitidos)) {
                /* converte o tamanho para KB */
                $this->tamanho = round($this->tamanho_imagem / 1024);

                if ($this->tamanho < 1024) { //se imagem for até 300kb envia
                    $largura = 200;
                    $altura = 200;
                    $image_size = getimagesize($_FILES['imagem']['tmp_name']);

                    // verifica tamanho
                    if ($image_size[0] < $largura || $image_size[1] < $altura) {
                        echo "A largura e altura mínima da imagem deve ser de 200px";
                        return false;
                    }

                    // verifica tamanho
                    $nome_atual = md5(uniqid(time())) . $this->ext; //nome que dará a imagem
                    $tmp = $_FILES['imagem']['tmp_name']; //caminho temporário da imagem

                    if ($this->getFoto() != "") {
                        $fotoperfil = $this->getFoto();
                        unlink("$this->pasta$fotoperfil");
                    }

                    /* se enviar a foto, insere o nome da foto no banco de dados */
                    if (move_uploaded_file($tmp, $this->pasta . $nome_atual)) {
                        require_once __DIR__ . '/../functions/connect.php';
                        $sql = "UPDATE 4f_cadastros SET foto = ? WHERE hash_user = ?";
                        $stmt = $mysqli->prepare($sql);

                        if (!$stmt) {
                            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                            return false;
                        }

                        $imagem = $nome_atual;
                        $stmt->bind_param('ss', $imagem, $dc->getHash_user());
                        $stmt->execute();

                        print '<script>window.location.replace("/app/user/minha-conta/?r=1");</script>';
                    } else {
                        print '<script>window.location.replace("/app/user/minha-conta/?r=2");</script>';
                    }
                } else {
                    print '<script>window.location.replace("/app/user/minha-conta/?r=3");</script>';
                }
            } else {
                print '<script>window.location.replace("/app/user/minha-conta/?r=4");</script>';
            }
        } else {
            print '<script>window.location.replace("/app/user/minha-conta/?r=5");</script>';
        }
    }

}

class LembrarSenha extends Cadastros {

    function Esqueci_Senha($email) {
        date_default_timezone_set('America/Sao_Paulo');

        session_start();
        include "./functions/connect.php";
        include "./functions/validacoes.php";

        $preerro = '
<div class="alert alert-danger" role="alert">
<span class="badge badge-pill badge-danger">Erro: </span>
            ';

        $poserro = '</div>';

        $sql = "SELECT id_cadastro, status, cnpj, razaosocial, nome "
                . "FROM 4f_cadastros "
                . "WHERE email = ? ";

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('s', $email);
        $stmt->execute();


        $stmt->bind_result($id_cadastro, $status_user, $cnpj, $razaosocial, $nome_user);

        $stmt->store_result();

        if ($stmt->num_rows() === 0) {
            echo $preerro;
            echo "Email não cadastrado na 4Fretes.";
            echo $poserro;
            exit;
        }

        if ($status_user == 2) {
            echo $preerro;
            echo "Conta não confirmada. Confirme sua conta para alterar seus dados.";
            echo $poserro;
            exit;
        }

        while ($stmt->fetch()) {
            $this->id_cadastro = $id_cadastro;
            $this->cnpj = $cnpj;
            $this->razaosocial = $razaosocial;
            $this->email = $email;
            $this->status = $status_user;
            $this->nome = ucwords(strtolower($nome_user));
            $this->pnome = explode(" ", $this->nome);
            $this->pnome = $this->pnome[0];
        }

        // cadastra o log de segurança
        $sql = "INSERT INTO 4f_alterasenha
		SET id_cadastro = ?, data = ?, ipsolicitacao = ?, status = ?";

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }
        $dataatual = new DateTime();
        $ipsolicitacao = $_SERVER["REMOTE_ADDR"];
        $status = "1";

        $stmt->bind_param('isss', $this->id_cadastro, $dataatual->format("Y-m-d H:i:s"), $ipsolicitacao, $status);
        $stmt->execute();
        $idtoken = $stmt->insert_id;
        $stmt->close();

        // Envia email
        $assuntoemail = $this->pnome . ", altere sua senha na 4Fretes!";
        $titulomsg = "Altere a sua senha";
        $tokenconfirmacao = md5($cnpj . $idtoken);

        $msgemail = "<h1 style=\"color:#333333;font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif;font-size:30px;font-weight:300;line-height:120%;margin:0;text-align:center;\">Olá, $this->nome!</h1>
	
	<p style=\"color:#666666;font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif;font-size:16px;font-weight:300;line-height:150%;margin:0;text-align:center;\">Parece que você solicitou a recuperação de senha na 4Fretes. <br /> Por questões de segurança, sua senha é criptografada e não podemos recuperá-la. Então é só clicar no link a seguir e criar uma nova senha. :)</p>";

        $rodapeemail = "<a href=\"https://4fretes.com/alterar-senha/$tokenconfirmacao/$this->email\" title=\"Clique aqui para alterar sua senha\" style=\"color:white;text-decoration:none;background-color:#00468C;display:inline-block;border-radius:3px;padding:0.75em;border-bottom:3px solid #000033; font-size:14px; width:270px;height:26px;line-height:26px; font-weight:bold; margin-top:24px;margin-bottom:10px\" target=\"_blank\"><span class=\"il\">CONFIRMAR</span> EMAIL</a><p style=\"margin:0px 0;font-size:12px;color:#666666;font-weight:lighter;line-height:20px\">
                            Se tiver problemas, copie e cole o link a seguir em outra janela do seu navegador: https://4fretes.com/alterar-senha/$tokenconfirmacao/$this->email</p> \n  \n";

        $this->Email_EsqueciSenha($this->nome, $this->email, $assuntoemail, $msgemail, $titulomsg, $rodapeemail);

        $_SESSION['temp_mail'] = hiddenMail($email);
        echo "<script>
		window.location.href = \"/app/lembrar-senha/?step=2\";
            </script>";

        return true;
    }

    function Email_EsqueciSenha($nome, $email, $assuntoemail, $msgemail, $titulomsg, $rodapeemail) {

        session_start();
        include "./functions/connect.php";

        // emails para quem será enviado o formulário
        $de = "no-reply@4fretes.com";
        $destino = $email;
        $assunto = $assuntoemail;

        // Adiciona o arquivo class.phpmailer.php - você deve especificar corretamente o caminho da pasta com o este arquivo.
        require_once("./autenvio/PHPMailerAutoload.php");
        // Inicia a classe PHPMailer
        $mail = new PHPMailer();

        // DEFINIÇÃO DOS DADOS DE AUTENTICAÇÃO - Você deve auterar conforme o seu domínio!
        $mail->IsSMTP(); // Define que a mensagem será SMTP
        $mail->Host = "mail.4fretes.com"; // Seu endereço de host SMTP
        $mail->SMTPAuth = true; // Define que será utilizada a autenticação -  Mantenha o valor "true"
        $mail->Port = 587; // Porta de comunicação SMTP - Mantenha o valor "587"
        $mail->SMTPSecure = false; // Define se é utilizado SSL/TLS - Mantenha o valor "false"
        $mail->SMTPAutoTLS = false; // Define se, por padrão, será utilizado TLS - Mantenha o valor "false"
        $mail->Username = 'no-reply@4fretes.com'; // Conta de email existente e ativa em seu domínio
        $mail->Password = 'n321reply'; // Senha da sua conta de email
        // DADOS DO REMETENTE
        $mail->Sender = "no-reply@4fretes.com"; // Conta de email existente e ativa em seu domínio
        $mail->From = "no-reply@4fretes.com"; // Sua conta de email que será remetente da mensagem
        $mail->FromName = "4Fretes"; // Nome da conta de email
        // DADOS DO DESTINATÁRIO
        $mail->AddAddress("$email", "$nome"); // Define qual conta de email receberá a mensagem
        //$mail->AddAddress('recebe2@dominio.com.br'); // Define qual conta de email receberá a mensagem
        //$mail->AddCC('copia@dominio.net'); // Define qual conta de email receberá uma cópia
        //$mail->AddBCC('copiaoculta@dominio.info'); // Define qual conta de email receberá uma cópia oculta
        // Definição de HTML/codificação
        $mail->IsHTML(true); // Define que o e-mail será enviado como HTML
        $mail->CharSet = 'utf-8'; // Charset da mensagem (opcional)
        // DEFINIÇÃO DA MENSAGEM
        $mail->Subject = "$assunto"; // Assunto da mensagem
        $mail->Body .= "<div style=\"background: #efefef; width: 100%; padding:30px 0;\"><div style=\"max-width: 600px; margin: 0 auto;  text-align:center; \">";
        $mail->Body .= "<img src=\"https://www.4fretes.com/images/logo-4fretes.png\" align=\"center\" alt=\"\"> <br><br><br>";

        $mail->Body .= "<div style=\"width: 100%; margin: 0 auto; border:1px solid #cccccc; background: #ffffff; text-align:center; border-radius:3px !important; \">";
        $mail->Body .= "<div style=\"max-width: 100%; background: #01588E; border-radius:3px 3px 0 0!important; padding:20px;\"> ";
        $mail->Body .= "<h1 style=\"color:#ffffff;font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif;font-size:30px;font-weight:300;line-height:110%;margin:0;text-align:center;\">$titulomsg</h1> ";
        $mail->Body .= "</div><br><br>";


        $mail->Body .= "<div style=\"width: 70%; margin: 0 auto; line-height:150%;\">$msgemail</div> <br>";

        $mail->Body .= "$rodapeemail";

        $mail->Body .= "<br><br><div style=\"margin: 0 auto; height: 35px; padding:10px 0 0 0; width:80%; border-top:1px solid #e2e2e2; font-size:10px;color:#666666\">EQUIPE <span style=\"color:#000000;font-weight:800;text-transform:uppercase\">SEGURO DE EVENTOS</span></div>";

        $mail->Body .= "</div>";
        $mail->Body .= "<br><br> Esta é uma mensagem automática, favor não responder este email. \n</div>";
        $mail->Body .= "</div>";


        // ENVIO DO EMAIL
        $enviado = $mail->Send();
        // Limpa os destinatários e os anexos
        $mail->ClearAllRecipients();

        // Exibe uma mensagem de resultado do envio (sucesso/erro)
        if ($enviado) {
            return true;
        } else {
            echo "Não foi possível enviar o e-mail.";
            echo "<b>Detalhes do erro:</b> " . $mail->ErrorInfo;
            exit;
        }
    }

    function Pre_Alteracao() {
        session_start();
        include "./functions/connect.php";
        require_once 'functions/antisqlinjection.php';

        $url = strip_tags($_SERVER['REQUEST_URI']);
        $url_array = explode("/", $url);
        // Excluimos o primeiro elemento, que sempre ser� vazio
        array_shift($url_array);

        $token = anti_sql_injection($url_array[2]);
        $emailusuario = anti_sql_injection($url_array[3]);

        $sql = "SELECT s.id_alterasenha, s.id_cadastro, s.data, s.ipsolicitacao, s.status, c.nome, c.cnpj, c.razaosocial  "
                . "FROM 4f_cadastros AS c "
                . "INNER JOIN 4f_alterasenha AS s "
                . "ON s.id_cadastro = c.id_cadastro "
                . "WHERE c.email = ? "
                . "ORDER BY s.data DESC LIMIT 1";

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('s', $emailusuario);
        $stmt->execute();

        $stmt->bind_result($idalterarsenha, $id_cadastro, $datasolicitacao, $ipsolicitacao, $statussolicitacao, $nomeusuario, $cnpjusuario, $razaosocial);

        $stmt->store_result();
        $stmt->num_rows();

        if ($stmt->num_rows() === 0) {
            echo "<script>
		window.location.href = \"/app/\";
            </script>";
            session_destroy();
            exit;
        }

        $retorno = array();

        while ($stmt->fetch()) {
            $data['idalterasenha'] = $idalterarsenha;
            $data['idcadastro'] = $id_cadastro;

            $datasolicitacao = new DateTime($datasolicitacao);
            $data['datasolicitacao'] = $datasolicitacao->format("d/m/Y H:i:s");
            $data['nomeusuario'] = ucfirst($nomeusuario);
            $data['cnpjusuario'] = $cnpjusuario;

            $tokenconfirmacao = md5($cnpjusuario . $idalterarsenha);
            $data['token'] = $tokenconfirmacao;
            $data['emailusuario'] = $emailusuario;

            if ($tokenconfirmacao !== $token) {
                $data['statussolicitacao'] = 0;
            } else {
                $data['statussolicitacao'] = $statussolicitacao;
            }

            array_push($retorno, $data);
        }

        return $retorno;
    }

    function Altera_Esqueci_Senha($nsenha) {
        session_start();
        include "./functions/connect.php";
        require_once 'functions/antisqlinjection.php';

        $token = $_SESSION['temp_token'];
        $emailusuario = $_SESSION['temp_email'];
        $idalterar = $_SESSION['temp_idalterar'];
        session_destroy();

        $sql = "SELECT s.id_alterasenha, s.id_cadastro, s.data, s.status, c.cnpj  "
                . "FROM 4f_cadastros AS c "
                . "INNER JOIN 4f_alterasenha AS s "
                . "ON s.id_cadastro = c.id_cadastro "
                . "WHERE c.email = ? "
                . "ORDER BY s.data DESC LIMIT 1";

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('s', $emailusuario);
        $stmt->execute();
        $stmt->bind_result($idalterarsenha, $id_cadastro, $datasolicitacao, $statussolicitacao, $cnpjusuario);
        $stmt->store_result();
        $stmt->num_rows();

        if ($stmt->num_rows() === 0) {
            echo "<script>
		window.location.href = \"/app/\";
            </script>";
            session_destroy();
            exit;
        } else {

            while ($stmt->fetch()) {

                $nsenha = md5($nsenha);

                //ALTERA A SENHA
                $sql = "UPDATE 4f_cadastros 
		SET senha = ?
		WHERE id_cadastro = ?";
                $stmt = $mysqli->prepare($sql);

                if (!$stmt) {
                    echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                    return false;
                }

                $stmt->bind_param('ss', $nsenha, $id_cadastro);
                $stmt->execute();
                $stmt->close();

                //ALTERA O LOG DE ALTERAÇÃO
                $sql = "UPDATE 4f_alterasenha 
		SET status = ?, dataalteracao = ?, ipalteracao = ?
		WHERE id_alterasenha = ?";
                $stmt = $mysqli->prepare($sql);

                if (!$stmt) {
                    echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                    return false;
                }

                $status = "0";
                date_default_timezone_set('America/Sao_Paulo');
                $dataatual = new DateTime();
                $ipalteracao = $_SERVER["REMOTE_ADDR"];

                $stmt->bind_param('ssss', $status, $dataatual->format("Y-m-d H:i:s"), $ipalteracao, $idalterar);
                $stmt->execute();
                $stmt->close();

                session_start();
                $_SESSION['temp_status_alteracao'] = '1';

                echo "<script>
		window.location.href = \"/app/entrar/\";
            </script>";

                return true;
            }
        }
    }

}

class CidadeUF extends Cadastros {

    function GetEstados() {
        include __DIR__ . "/../functions/connect.php";
        session_start();

        $sql = "SELECT Id, CodigoUf, Nome, Uf, Regiao "
                . "FROM 4f_estados "
                . "ORDER BY Uf ";

        $mysqli->query($sql);
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->execute();
        $stmt->bind_result($id, $codigouf, $nome, $uf, $regiao);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['uf'] = $uf;
            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function GetCidades($cid) {
        include __DIR__ . "/../functions/connect.php";
        session_start();

        $sql = "SELECT Id, Nome "
                . "FROM 4f_municipios "
                . "WHERE Uf = ? "
                . "ORDER BY Uf ";

        $mysqli->query($sql);
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }



        $stmt->bind_param('s', $cid);
        $stmt->execute();
        $stmt->bind_result($id, $nome);

        $retorno = "<option disabled=\"disabled\" selected=\"selected\" value=\"\">Selecione a sua cidade...</option>";

        while ($stmt->fetch()) {
            $retorno .= "<option value='" . $id . "'>" . $nome . "</option>";
        }

        return $retorno;
        $stmt->close();
    }

    function NomeCidade($cid) {
        include __DIR__ . "/../functions/connect.php";
        session_start();

        $sql = "SELECT Nome "
                . "FROM 4f_municipios "
                . "WHERE Id = ? ";

        $mysqli->query($sql);
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }


        $stmt->bind_param('i', $cid);
        $stmt->execute();
        $stmt->bind_result($nome);

        while ($stmt->fetch()) {
            $retorno = $nome;
        }

        return $retorno;
        $stmt->close();
    }

}
