<?php

class Site {

    function subNoticias() {
        session_start();
        include "./functions/connect.php";

        $query = $mysqli->query("SELECT * FROM sde_noticias_cat ORDER BY nome ASC");

        while ($row = $query->fetch_array()) {

            echo '<li><a href="/pasrhsenior/noticias/' . $row['urlamigavel'] . '">' . $row['nome'] . '</a></li>';
        }
    }
    
    function subSeguros() {
        session_start();
        include "./functions/connect.php";

        $query = $mysqli->query("SELECT * FROM sde_seguros ORDER BY titulo ASC");

        while ($row = $query->fetch_array()) {

            echo '<li><a href="/pasrhsenior/' . $row['urlamigavel'] . '">' . $row['titulo'] . '</a></li>';
        }
    }

    function subDicas() {
        session_start();
        include "./functions/connect.php";

        $query = $mysqli->query("SELECT * FROM sde_dicas_cat ORDER BY nome ASC");

        while ($row = $query->fetch_array()) {

            echo '<li><a href="/pasrhsenior/dicas/' . $row['urlamigavel'] . '">' . $row['nome'] . '</a></li>';
        }
    }

    function Pega_Conteudo($pagina) {
        include "./functions/connect.php";

        $sql = "SELECT conteudo
                    FROM sde_conteudo			
                    WHERE pag_conteudo = ?
                    ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }
        $stmt->bind_param('s', $pagina);
        $stmt->execute();
        $stmt->bind_result($descricao);

        while ($stmt->fetch()) {
            return $descricao;
        }

        $stmt->close();
    }

}

class Home extends Site {

    function NoticiasHome($categoria, $limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');


        $sql = "SELECT d.id_noticia, d.titulo, d.urlamigavel, d.datadecadastro, c.nome, d.imagemdestacada
                FROM sde_noticias AS d
                INNER JOIN sde_noticias_cat AS c
                ON d.cat_not = c.id_categoria              
                WHERE d.cat_not = ?
                ORDER BY d.datadecadastro DESC
                LIMIT ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('ii', $categoria, $limite);
        $stmt->execute();
        $stmt->bind_result($id_not, $titulo, $urlamigavel, $datadecadastro, $nomecategoria, $imagemdestacada);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_not;
            $data['titulo'] = ucfirst($titulo);
            //$datadecadastro = new DateTime($datadecadastro);
            $datadecadastro = strftime('%d de %B', strtotime($datadecadastro));

            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['imagemdestacada'] = $imagemdestacada;

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function DicasHome($categoria, $limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');


        $sql = "SELECT d.id_dica, d.titulo, d.urlamigavel, d.datadecadastro, c.nome, d.imagemdestacada
                FROM sde_dicas AS d
                INNER JOIN sde_dicas_cat AS c
                ON d.cat_dica = c.id_categoria              
                WHERE d.cat_dica = ?
                ORDER BY d.datadecadastro DESC
                LIMIT ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('ii', $categoria, $limite);
        $stmt->execute();
        $stmt->bind_result($id_dica, $titulo, $urlamigavel, $datadecadastro, $nomecategoria, $imagemdestacada);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_dica;
            $data['titulo'] = ucfirst($titulo);
            //$datadecadastro = new DateTime($datadecadastro);
            $datadecadastro = strftime('%d de %B', strtotime($datadecadastro));

            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['imagemdestacada'] = $imagemdestacada;

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function DocumentosHome($limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');


        $sql = "SELECT d.id_doc, d.nome, d.urlamigavel, d.datadecadastro, c.nome
                FROM sde_docs AS d
                INNER JOIN sde_docs_cat AS c
                ON d.cat_doc = c.id_categoria                            
                ORDER BY d.datadecadastro DESC
                LIMIT ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('i', $limite);
        $stmt->execute();
        $stmt->bind_result($id_doc, $titulo, $urlamigavel, $datadecadastro, $nomecategoria);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_doc;
            $data['titulo'] = ucfirst($titulo);
            $datadecadastro = strftime('%d de %B', strtotime($datadecadastro));
            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['nomecategoria'] = ucfirst($nomecategoria);
            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function SliderHome($limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');


        $sql = "SELECT d.id_noticia, d.titulo, d.urlamigavel, d.datadecadastro, c.nome, d.imagemdestacada
                FROM sde_noticias AS d
                INNER JOIN sde_noticias_cat AS c
                ON d.cat_not = c.id_categoria              
                WHERE d.imagemdestacada is not null
                ORDER BY d.datadecadastro DESC
                LIMIT ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('i', $limite);
        $stmt->execute();
        $stmt->bind_result($id_not, $titulo, $urlamigavel, $datadecadastro, $nomecategoria, $imagemdestacada);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_not;
            $data['titulo'] = ucfirst($titulo);
            //$datadecadastro = new DateTime($datadecadastro);
            $datadecadastro = strftime('%d de %B', strtotime($datadecadastro));

            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['imagemdestacada'] = $imagemdestacada;

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

}

class Noticias extends Site {

    function ListaNoticias($limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');
        
        $pag = filter_input(INPUT_GET, 'pag', FILTER_VALIDATE_INT);
        if (empty($pag)){ $pag = 1; }       
        $inicio = $pag - 1;
        $inicio = $inicio * $limite;

        $sql = "SELECT d.id_noticia, d.titulo, d.conteudoaberto, d.urlamigavel, d.datadecadastro, c.nome, d.imagemdestacada
                FROM sde_noticias AS d
                INNER JOIN sde_noticias_cat AS c
                ON d.cat_not = c.id_categoria              
                
                ORDER BY d.datadecadastro DESC
                LIMIT ?, ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('ii', $inicio, $limite);
        $stmt->execute();
        $stmt->bind_result($id_not, $titulo, $conteudoaberto, $urlamigavel, $datadecadastro, $nomecategoria, $imagemdestacada);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_not;
            $data['titulo'] = ucfirst($titulo);
            //$datadecadastro = new DateTime($datadecadastro);
            $datadecadastro = ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro)));

            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['imagemdestacada'] = $imagemdestacada;

            $data['conteudoaberto'] = strip_tags(substr($conteudoaberto, 0, 200));

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function PegaNoticia($url_not) {
        include "./functions/connect.php";
        session_start();
        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');

        $sql = "SELECT n.cat_not, n.titulo, n.conteudoaberto, n.conteudofechado, n.datadecadastro, n.imagemdestacada, c.nome
                FROM sde_noticias AS n
                INNER JOIN sde_noticias_cat AS c
                ON n.cat_not = c.id_categoria
                WHERE n.urlamigavel = ?          
                ";

        $mysqli->query($sql);

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param("s", $url_not);

        $stmt->execute();
        $stmt->bind_result($categoria, $titulo, $conteudoaberto, $conteudofechado, $datadecadastro, $imagemdestacada, $nomecategoria);

        $retorno = array();

        while ($stmt->fetch()) {
            // retorna array      
            $data['id'] = $id_not;
            $data['titulo'] = $titulo;
            $data['imagemdestacada'] = $imagemdestacada;
            $data['datadecadastro'] = ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro)));
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['categoria'] = ucfirst($categoria);
            $data['conteudoaberto'] = ucfirst($conteudoaberto);
            $data['conteudofechado'] = ucfirst($conteudofechado);
            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function SBCategorias() {
        session_start();
        include "./functions/connect.php";

        $query = $mysqli->query("SELECT * FROM sde_noticias_cat ORDER BY nome ASC");

        while ($row = $query->fetch_array()) {
            $catnum = $this->SBContaNotsCategorias($row['id_categoria']);
            echo '<a href="/pasrhsenior/noticias/' . $row['urlamigavel'] . '">' . $row['nome'] . '
                  <span class="badge badge-primary">' . $catnum . '</span>
                </a>';
        }
    }
    
    function ContaNoticias() {
        session_start();
        include "./functions/connect.php";

        $sql = "SELECT id_noticia FROM sde_noticias";
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->execute();
        $result = $stmt->get_result();
        $total = $result->num_rows;
        return $total;
        $stmt->close();
    }

    function SBContaNotsCategorias($cat) {
        session_start();
        include "./functions/connect.php";

        $sql = "SELECT id_noticia FROM sde_noticias WHERE cat_not = ?";
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }
        $stmt->bind_param("s", $cat);
        $stmt->execute();
        $result = $stmt->get_result();
        $total = $result->num_rows;
        return $total;
        $stmt->close();
    }

    function Pega_Categoria($urlcat) {
        include "./functions/connect.php";

        if ($status == '') {
            $sql = "SELECT id_categoria, nome, descricao
                    FROM sde_noticias_cat			
                    WHERE urlamigavel = ?
                    ";

            $mysqli->query($sql);

            //prepara os dados
            $stmt = $mysqli->prepare($sql);

            if (!$stmt) {
                echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                return false;
            }
            $stmt->bind_param('s', $urlcat);
            $stmt->execute();
            $stmt->bind_result($id_categoria, $nome, $descricao);
        }

        $retorno = array();

        while ($stmt->fetch()) {
            // retorna array      
            $data['id_categoria'] = $id_categoria;
            $data['nome'] = ucfirst($nome);
            $data['descricao'] = $descricao;

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function ListaNoticiasPorCat($categoria, $limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');
        
        $pag = filter_input(INPUT_GET, 'pag', FILTER_VALIDATE_INT);
        if (empty($pag)){ $pag = 1; }       
        $inicio = $pag - 1;
        $inicio = $inicio * $limite;

        $sql = "SELECT d.id_noticia, d.titulo, d.conteudoaberto, d.urlamigavel, d.datadecadastro, c.nome, d.imagemdestacada
                FROM sde_noticias AS d
                INNER JOIN sde_noticias_cat AS c
                ON d.cat_not = c.id_categoria              
                WHERE cat_not = ?
                ORDER BY d.datadecadastro DESC
                LIMIT ?, ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('iii', $categoria, $inicio, $limite);
        $stmt->execute();
        $stmt->bind_result($id_not, $titulo, $conteudoaberto, $urlamigavel, $datadecadastro, $nomecategoria, $imagemdestacada);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_not;
            $data['titulo'] = ucfirst($titulo);
            //$datadecadastro = new DateTime($datadecadastro);
            $datadecadastro = ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro)));

            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['imagemdestacada'] = $imagemdestacada;

            $data['conteudoaberto'] = strip_tags(substr($conteudoaberto, 0, 200));

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

}

class Seguros extends Site {

    function ListaSeguros($limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');


        $sql = "SELECT d.id_seguro, d.titulo, d.conteudo, d.urlamigavel, d.datadecadastro, d.imagemdestacada
                FROM sde_seguros AS d
                ORDER BY d.datadecadastro DESC
                LIMIT ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('i', $limite);
        $stmt->execute();
        $stmt->bind_result($id_seg, $titulo, $conteudo, $urlamigavel, $datadecadastro, $imagemdestacada);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_not;
            $data['titulo'] = ucfirst($titulo);
            //$datadecadastro = new DateTime($datadecadastro);
            $datadecadastro = ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro)));

            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['imagemdestacada'] = $imagemdestacada;

            $data['conteudo'] = strip_tags(substr($conteudo, 0, 200));

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function PegaSeguro($url_seg) {
        include "./functions/connect.php";
        session_start();
        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');

        $sql = "SELECT n.titulo, n.conteudo, n.datadecadastro, n.imagemdestacada
                FROM sde_seguros AS n
                WHERE n.urlamigavel = ?          
                ";

        $mysqli->query($sql);

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param("s", $url_seg);

        $stmt->execute();
        $stmt->bind_result($titulo, $conteudo, $datadecadastro, $imagemdestacada);

        $retorno = array();

        while ($stmt->fetch()) {
            // retorna array      
            $data['id'] = $id_seg;
            $data['titulo'] = $titulo;
            $data['imagemdestacada'] = $imagemdestacada;
            $data['datadecadastro'] = ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro)));
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['conteudo'] = ucfirst($conteudo);
            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }
    
     function VerificaSeguro($slugpagina) {
        include "./functions/connect.php";
        require_once "./functions/antisqlinjection.php";
        $slugpagina = anti_sql_injection($slugpagina);

        $sql = "SELECT id_seguro 
                FROM sde_seguros 
                WHERE urlamigavel = ?          
                ";

        $mysqli->query($sql);

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param("s", $slugpagina);

        $stmt->execute();
        $stmt->bind_result($id_seguro);

        $result = $stmt->get_result();
        $total = $result->num_rows;

        return $total;
        $stmt->close();
    }

}

class Documentos extends Site {

    function ListaDocumentos($limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');


        $sql = "SELECT d.id_doc, d.nome, d.descricao, d.urlamigavel, d.datadecadastro, c.nome
                FROM sde_docs AS d
                INNER JOIN sde_docs_cat AS c
                ON d.cat_doc = c.id_categoria              
                
                ORDER BY d.datadecadastro DESC
                LIMIT ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('i', $limite);
        $stmt->execute();
        $stmt->bind_result($id_doc, $nome, $descricao, $urlamigavel, $datadecadastro, $nomecategoria);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_doc;
            $data['titulo'] = ucfirst($nome);
            //$datadecadastro = new DateTime($datadecadastro);
            $datadecadastro = utf8_encode(ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro))));

            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['descricao'] = strip_tags(substr($descricao, 0, 200));

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function PegaDocumento($url_doc) {
        include "./functions/connect.php";
        session_start();
        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');

        $sql = "SELECT d.id_doc, d.cat_doc, d.nome, d.descricao, d.datadecadastro, c.nome
                FROM sde_docs AS d
                INNER JOIN sde_docs_cat AS c
                ON d.cat_doc = c.id_categoria
                WHERE d.urlamigavel = ?          
                ";

        $mysqli->query($sql);

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param("s", $url_doc);

        $stmt->execute();
        $stmt->bind_result($id_doc, $categoria, $nome, $descricao, $datadecadastro, $nomecategoria);

        $retorno = array();

        while ($stmt->fetch()) {
            // retorna array      
            $data['id'] = $id_doc;
            $data['titulo'] = $nome;
            $data['datadecadastro'] = utf8_encode(ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro))));
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['categoria'] = ucfirst($categoria);
            $data['descricao'] = ucfirst($descricao);
            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function MostraDownloadDocumento($iddoc) {
        include "./functions/connect.php";
        session_start();

        $id_doc = (int)$iddoc;

        $sql = "SELECT id_arquivo, url
                FROM sde_docs_arquivos                                
                WHERE id_doc = ?
                ORDER BY url ASC             
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param("i", $id_doc);

        $stmt->execute();
        $stmt->bind_result($id_arquivo, $urlarquivo);

        $retorno = array();

        while ($stmt->fetch()) {
            
            echo "<a href='/pasrhsenior/doc/$urlarquivo' target='_blank' style='color: #666;'>
                    <button class='btn-lg btn-secondary'>
                    <i class='fas fa-download'></i> CLIQUE AQUI PARA FAZER O DOWNLOAD
                    </button>
            </a>";
          
        }

        $stmt->close();
    }

    function SBCategoriasDOCS() {
        session_start();
        include "./functions/connect.php";

        $query = $mysqli->query("SELECT * FROM sde_docs_cat ORDER BY nome ASC");

        while ($row = $query->fetch_array()) {
            $catnum = $this->SBContaDocsCategorias($row['id_categoria']);
            echo '<a href="/pasrhsenior/documentos/' . $row['urlamigavel'] . '">' . $row['nome'] . '
                  <span class="badge badge-primary">' . $catnum . '</span>
                </a>';
        }
    }

    function SBContaDocsCategorias($cat) {
        session_start();
        include "./functions/connect.php";

        $sql = "SELECT id_doc FROM sde_docs WHERE cat_doc = ?";
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }
        $stmt->bind_param("s", $cat);
        $stmt->execute();
        $result = $stmt->get_result();
        $total = $result->num_rows;
        return $total;
        $stmt->close();
    }

    function Pega_Categoria($urlcat) {
        include "./functions/connect.php";

        if ($status == '') {
            $sql = "SELECT id_categoria, nome, descricao
                    FROM sde_docs_cat			
                    WHERE urlamigavel = ?
                    ";

            $mysqli->query($sql);

            //prepara os dados
            $stmt = $mysqli->prepare($sql);

            if (!$stmt) {
                echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                return false;
            }
            $stmt->bind_param('s', $urlcat);
            $stmt->execute();
            $stmt->bind_result($id_categoria, $nome, $descricao);
        }

        $retorno = array();

        while ($stmt->fetch()) {
            // retorna array      
            $data['id_categoria'] = $id_categoria;
            $data['nome'] = ucfirst($nome);
            $data['descricao'] = $descricao;

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function ListaDocumentosPorCat($categoria, $limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');


        $sql = "SELECT d.id_doc, d.nome, d.descricao, d.urlamigavel, d.datadecadastro, c.nome
                FROM sde_docs AS d
                INNER JOIN sde_docs_cat AS c
                ON d.cat_doc = c.id_categoria              
                WHERE cat_doc = ?
                ORDER BY d.datadecadastro DESC
                LIMIT ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('ii', $categoria, $limite);
        $stmt->execute();
        $stmt->bind_result($id_doc, $titulo, $descricao, $urlamigavel, $datadecadastro, $nomecategoria);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_doc;
            $data['titulo'] = ucfirst($titulo);
            //$datadecadastro = new DateTime($datadecadastro);
            $datadecadastro = ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro)));

            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['nomecategoria'] = ucfirst($nomecategoria);

            $data['descricao'] = strip_tags(substr($descricao, 0, 200));

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

}

class Dicas extends Site {

    function ListaDicas($limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');


        $sql = "SELECT d.id_dica, d.titulo, d.conteudoaberto, d.urlamigavel, d.datadecadastro, c.nome, d.imagemdestacada
                FROM sde_dicas AS d
                INNER JOIN sde_dicas_cat AS c
                ON d.cat_dica = c.id_categoria              
                
                ORDER BY d.datadecadastro DESC
                LIMIT ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('i', $limite);
        $stmt->execute();
        $stmt->bind_result($id_dica, $titulo, $conteudoaberto, $urlamigavel, $datadecadastro, $nomecategoria, $imagemdestacada);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_dica;
            $data['titulo'] = ucfirst($titulo);
            //$datadecadastro = new DateTime($datadecadastro);
            $datadecadastro = ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro)));

            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['imagemdestacada'] = $imagemdestacada;

            $data['conteudoaberto'] = strip_tags(substr($conteudoaberto, 0, 200));

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function PegaDica($url_dica) {
        include "./functions/connect.php";
        session_start();
        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');

        $sql = "SELECT n.cat_dica, n.titulo, n.conteudoaberto, n.conteudofechado, n.datadecadastro, n.imagemdestacada, c.nome
                FROM sde_dicas AS n
                INNER JOIN sde_dicas_cat AS c
                ON n.cat_dica = c.id_categoria
                WHERE n.urlamigavel = ?          
                ";

        $mysqli->query($sql);

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param("s", $url_dica);

        $stmt->execute();
        $stmt->bind_result($categoria, $titulo, $conteudoaberto, $conteudofechado, $datadecadastro, $imagemdestacada, $nomecategoria);

        $retorno = array();

        while ($stmt->fetch()) {
            // retorna array      
            $data['id'] = $id_dica;
            $data['titulo'] = $titulo;
            $data['imagemdestacada'] = $imagemdestacada;
            $data['datadecadastro'] = ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro)));
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['categoria'] = ucfirst($categoria);
            $data['conteudoaberto'] = ucfirst($conteudoaberto);
            $data['conteudofechado'] = ucfirst($conteudofechado);
            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function SBCategorias() {
        session_start();
        include "./functions/connect.php";

        $query = $mysqli->query("SELECT * FROM sde_dicas_cat ORDER BY nome ASC");

        while ($row = $query->fetch_array()) {
            $catnum = $this->SBContaDicasCategorias($row['id_categoria']);
            echo '<a href="/pasrhsenior/dicas/' . $row['urlamigavel'] . '">' . $row['nome'] . '
                  <span class="badge badge-primary">' . $catnum . '</span>
                </a>';
        }
    }

    function SBContaDicasCategorias($cat) {
        session_start();
        include "./functions/connect.php";

        $sql = "SELECT id_dica FROM sde_dicas WHERE cat_dica = ?";
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }
        $stmt->bind_param("s", $cat);
        $stmt->execute();
        $result = $stmt->get_result();
        $total = $result->num_rows;
        return $total;
        $stmt->close();
    }

    function Pega_Categoria($urlcat) {
        include "./functions/connect.php";

        if ($status == '') {
            $sql = "SELECT id_categoria, nome, descricao
                    FROM sde_dicas_cat			
                    WHERE urlamigavel = ?
                    ";

            $mysqli->query($sql);

            //prepara os dados
            $stmt = $mysqli->prepare($sql);

            if (!$stmt) {
                echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
                return false;
            }
            $stmt->bind_param('s', $urlcat);
            $stmt->execute();
            $stmt->bind_result($id_categoria, $nome, $descricao);
        }

        $retorno = array();

        while ($stmt->fetch()) {
            // retorna array      
            $data['id_categoria'] = $id_categoria;
            $data['nome'] = ucfirst($nome);
            $data['descricao'] = $descricao;

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

    function ListaDicasPorCat($categoria, $limite) {
        include "./functions/connect.php";

        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');


        $sql = "SELECT d.id_dica, d.titulo, d.conteudoaberto, d.urlamigavel, d.datadecadastro, c.nome, d.imagemdestacada
                FROM sde_dicas AS d
                INNER JOIN sde_dicas_cat AS c
                ON d.cat_dica = c.id_categoria              
                WHERE cat_dica = ?
                ORDER BY d.datadecadastro DESC
                LIMIT ?
                ";

        $mysqli->query($sql);

        //prepara os dados
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('ii', $categoria, $limite);
        $stmt->execute();
        $stmt->bind_result($id_dica, $titulo, $conteudoaberto, $urlamigavel, $datadecadastro, $nomecategoria, $imagemdestacada);

        $retorno = array();

        while ($stmt->fetch()) {
            $data['id'] = $id_dica;
            $data['titulo'] = ucfirst($titulo);
            //$datadecadastro = new DateTime($datadecadastro);
            $datadecadastro = ucfirst(strftime('%A, %d de %B de %Y', strtotime($datadecadastro)));

            $data['datadecadastro'] = $datadecadastro;
            $data['urlamigavel'] = $urlamigavel;
            $data['nomecategoria'] = ucfirst($nomecategoria);
            $data['imagemdestacada'] = $imagemdestacada;

            $data['conteudoaberto'] = strip_tags(substr($conteudoaberto, 0, 200));

            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

}

class Paginas extends Site {

    function VerificaPagina($slugpagina) {
        include "./functions/connect.php";
        require_once "./functions/antisqlinjection.php";
        $slugpagina = anti_sql_injection($slugpagina);

        $sql = "SELECT id_pagina 
                FROM sde_paginas 
                WHERE urlamigavel = ?          
                ";

        $mysqli->query($sql);

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param("s", $slugpagina);

        $stmt->execute();
        $stmt->bind_result($id_pagina);

        $result = $stmt->get_result();
        $total = $result->num_rows;

        return $total;
        $stmt->close();
    }

    function PegaPagina($slugpagina) {
        include "./functions/connect.php";
        require_once "./functions/antisqlinjection.php";
        $slugpagina = anti_sql_injection($slugpagina);

        $sql = "SELECT titulo, conteudo 
                FROM sde_paginas 
                WHERE urlamigavel = ?";

        $mysqli->query($sql);

        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param("s", $slugpagina);
        $stmt->execute();
        $stmt->bind_result($titulo, $conteudo);

        $retorno = array();

        while ($stmt->fetch()) {
            // retorna array      
            $data['titulo'] = $titulo;
            $data['conteudo'] = $conteudo;
            array_push($retorno, $data);
        }

        return $retorno;
        $stmt->close();
    }

}