<?php

function RealToBd($valor) {
    $valor = str_replace('.', '', $valor);
    $valor = str_replace(',', '.', $valor);
    $valor = str_replace('R$ ', '', $valor);

    return $valor;
}

function BdToReal($valor) {
    $valor = str_replace('.', ',', $valor);
    $valor = "R$ $valor";
    return $valor;
}

function hiddenMail($email) {
    $mail_segments = explode("@", $email);
    $mail_segments[0] = substr($email, 0, 3) . str_repeat("*", strlen($mail_segments[0]));
    return implode("@", $mail_segments);
}

// Funções para validar dados de formulários
//valida cnpj
function formatCnpjCpf($value)
{
  $cnpj_cpf = preg_replace("/\D/", '', $value);
  
  if (strlen($cnpj_cpf) === 11) {
    return preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "\$1.\$2.\$3-\$4", $cnpj_cpf);
  } 
  
  return preg_replace("/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/", "\$1.\$2.\$3/\$4-\$5", $cnpj_cpf);
}

function validaCNPJ($cnpj) {
    if (strlen($cnpj) <> 18)
        return 0;
    $soma1 = ($cnpj[0] * 5) +
            ($cnpj[1] * 4) +
            ($cnpj[3] * 3) +
            ($cnpj[4] * 2) +
            ($cnpj[5] * 9) +
            ($cnpj[7] * 8) +
            ($cnpj[8] * 7) +
            ($cnpj[9] * 6) +
            ($cnpj[11] * 5) +
            ($cnpj[12] * 4) +
            ($cnpj[13] * 3) +
            ($cnpj[14] * 2);
    $resto = $soma1 % 11;
    $digito1 = $resto < 2 ? 0 : 11 - $resto;
    $soma2 = ($cnpj[0] * 6) +
            ($cnpj[1] * 5) +
            ($cnpj[3] * 4) +
            ($cnpj[4] * 3) +
            ($cnpj[5] * 2) +
            ($cnpj[7] * 9) +
            ($cnpj[8] * 8) +
            ($cnpj[9] * 7) +
            ($cnpj[11] * 6) +
            ($cnpj[12] * 5) +
            ($cnpj[13] * 4) +
            ($cnpj[14] * 3) +
            ($cnpj[16] * 2);
    $resto = $soma2 % 11;
    $digito2 = $resto < 2 ? 0 : 11 - $resto;
    return (($cnpj[16] == $digito1) && ($cnpj[17] == $digito2));
}

function validaCPF($cpf) {

    // Extrai somente os números
    $cpf = preg_replace('/[^0-9]/is', '', $cpf);

    // Verifica se foi informado todos os digitos corretamente
    if (strlen($cpf) != 11) {
        return false;
    }
    // Verifica se foi informada uma sequência de digitos repetidos. Ex: 111.111.111-11
    if (preg_match('/(\d)\1{10}/', $cpf)) {
        return false;
    }
    // Faz o calculo para validar o CPF
    for ($t = 9; $t < 11; $t++) {
        for ($d = 0, $c = 0; $c < $t; $c++) {
            $d += $cpf{$c} * (($t + 1) - $c);
        }
        $d = ((10 * $d) % 11) % 10;
        if ($cpf{$c} != $d) {
            return false;
        }
    }

    if (!empty($cpf)) {
        /*
        return false;
        exit;

        // VERIFICA SE O CPF JÁ ESTÁ CADASTRADO
        include "./functions/connect.php";

        $sql = "SELECT id_cadastro "
                . "FROM 4f_cadastros WHERE cpf = ? "
                . "ORDER BY id_cadastro ASC LIMIT 1";

        $mysqli->query($sql);
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('s', $cpf);
        $stmt->execute();

        $result = $stmt->get_result();
        $total = $result->num_rows;

        if ($total > 0) {
            echo $preerro;
            echo "Esse CPF já está cadastrado.";
            echo $poserro;
            exit;
        }

        $stmt->close();
        
         */
    }

    return true;
         
         
}

//valida email
function validaEMAIL($email) {

    $preerro = '<span class="badge badge-pill badge-danger">Erro: </span>
            ';

    $poserro = '
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">×</span>
            </button>';

    $dominio = explode("@", $email);
    $dominio = $dominio[1];

    if (!empty($email)) {
        // VERIFICA SE O EMAIL JÁ ESTÁ CADASTRADO
        include "./functions/connect.php";

        $sql = "SELECT id_cadastro "
                . "FROM 4f_cadastros WHERE email = ? "
                . "ORDER BY id_cadastro ASC LIMIT 1";

        $mysqli->query($sql);
        $stmt = $mysqli->prepare($sql);

        if (!$stmt) {
            echo 'Erro na consulta: ' . $mysqli->errno . ' - ' . $mysqli->error;
            return false;
        }

        $stmt->bind_param('s', $email);
        $stmt->execute();
        $result = $stmt->get_result();
        $total = $result->num_rows;

        if ($total > 0) {
            echo $preerro;
            echo "Esse email já está cadastrado.";
            echo $poserro;
            exit;
        }

        $stmt->close();
    }

    if (empty($email)) {
        echo $preerro;
        echo "Informe um email.";
        echo $poserro;
        exit;
    } elseif (!checkdnsrr($dominio)) {
        echo $preerro;
        echo "Informe um email válido.";
        echo $poserro;
        exit;
    } else {
        return true;
    }
}

//valida senha
function validaSENHA($senhaestabelecimento, $csenhaestabelecimento) {

    $preerro = '<span class="badge badge-pill badge-danger">Erro: </span>
            ';

    $poserro = '
            ';


    $contagem1 = strlen($senhaestabelecimento);
    $contagem2 = strlen($csenhaestabelecimento);
    if ($contagem1 == "") {
        echo $preerro;
        echo "Informe uma senha.";
        echo $poserro;
        exit;
    } elseif ($senhaestabelecimento != $csenhaestabelecimento) {
        echo $preerro;
        echo "As senhas não conferem.";
        echo $poserro;
        exit;
    } elseif ($contagem1 < 6 || $contagem1 > 12) {
        echo $preerro;
        echo "A senha deve conter letra, número e ter entre 6 e 12 caracteres";
        echo $poserro;
        exit;
    } elseif (!preg_match("/([a-zA-Z]*([0-9]+[a-zA-Z]+)|([a-zA-Z]+[0-9]+)[0-9]*)+/", $senhaestabelecimento)) {
        echo $preerro;
        echo "A senha deve conter letra, número e ter entre 6 e 12 caracteres";
        echo $poserro;
        exit;
    } else {
        return true;
    }
}

//valida cep
function validaCEP($cep) {
    $cep = trim($cep);
    // expressao regular para avaliar o cep
    $avaliaCep = ereg("^[0-9]{5}-[0-9]{3}$", $cep);

    // verifica o resultado
    if (!$avaliaCep) {
        echo "<strong>Erro:</strong> CEP inválido";
    } else {
        return true;
    }
}


function validaDATANASCIMENTO($datanascimento) {


    if (!empty($datanascimento)) {
        $data = explode("-", "$datanascimento"); // fatia a string $dat em pedados, usando / como referência
        $d = (int) $data[2];
        $m = (int) $data[1];
        $y = (int) $data[0];



        // verifica se a data é válida!
        // 1 = true (válida)
        // 0 = false (inválida)
        $res = checkdate($m, $d, $y);



        if ($res == 0) {
            return "Data de nascimento inválida.";
            die();
        } else {
            $dataatual = new DateTime();
            $datanasc = date_create_from_format('Y-m-d', $datanascimento);

            $diff = $dataatual->diff($datanasc);
            $dif_anos = $diff->format('%y');


            if ($dif_anos < 18) {
                return "Você precisa ser maior de 18 anos para se cadastrar.";
                die();
            } elseif ($dif_anos > 100) {
                return "Parece que há algo errado com sua data de nascimento.";
                die();
            }
        }
    } 
}

//valida SEXO
function validaSEXO($sexo) {
    if (empty($sexo)) {
        echo "<strong>Erro:</strong> Informe o sexo (masculino ou feminino).";
        exit;
    } else {
        return true;
    }
}

//valida telefone fixo
function validaTELEFONEFIXO($telefonefixo) {
    if (empty($telefonefixo)) {
        echo "<strong>Erro:</strong> Informe um <strong>telefone</strong>.";
        exit;
    } else {
        return true;
    }
}

//valida endereço
function validaENDERECO($endereco) {
    if (empty($endereco)) {
        echo "<strong>Erro:</strong> Informe o <strong>endereço</strong>.";
        exit;
    } else {
        return true;
    }
}

//valida estado
function validaESTADO($estado) {
    if (empty($estado)) {
        echo "<strong>Erro:</strong> Selecione o <strong>estado</strong>.";
        exit;
    } else {
        return true;
    }
}

//valida cidade
function validaCIDADE($cidade) {
    if (empty($cidade)) {
        echo "<strong>Erro:</strong> Informe a <strong>cidade</strong>.";
        exit;
    } else {
        return true;
    }
}

//valida o bairro
function validaBAIRRO($bairro) {
    if (empty($bairro)) {
        echo "<strong>Erro:</strong> Informe o <strong>bairro</strong>.";
        exit;
    } else {
        return true;
    }
}

//valida o número do endereço
function validaNUMERO($numero) {
    if (empty($numero)) {
        echo "<strong>Erro:</strong> Informe o <strong>número do endereço</strong>.";
        exit;
    } else {
        return true;
    }
}
